VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   4830
   ClientLeft      =   1935
   ClientTop       =   1680
   ClientWidth     =   8040
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   4830
   ScaleWidth      =   8040
   Begin VB.ListBox List1 
      Height          =   2205
      Left            =   5520
      TabIndex        =   10
      Top             =   1320
      Width           =   1815
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   6600
      TabIndex        =   9
      Top             =   3840
      Width           =   855
   End
   Begin VB.Frame Frame1 
      Caption         =   "Clock Select"
      Height          =   975
      Left            =   3120
      TabIndex        =   6
      Top             =   1560
      Width           =   2055
      Begin VB.OptionButton optExternal 
         Caption         =   "External Clock"
         Height          =   195
         Left            =   360
         TabIndex        =   8
         Top             =   600
         Width           =   1335
      End
      Begin VB.OptionButton optInternal 
         Caption         =   "Internal Clock"
         Height          =   255
         Left            =   360
         TabIndex        =   7
         Top             =   240
         Value           =   -1  'True
         Width           =   1575
      End
   End
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   3120
      TabIndex        =   4
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   960
      Width           =   735
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      Height          =   375
      Left            =   600
      TabIndex        =   3
      Top             =   960
      Width           =   2295
   End
   Begin DlsrLib.DriverLINXLDD LDD 
      Left            =   1560
      Top             =   2280
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start Reading Digital Input"
      Enabled         =   0   'False
      Height          =   375
      Left            =   600
      TabIndex        =   1
      Top             =   1680
      Width           =   2295
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   720
      Top             =   2280
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label3 
      AutoSize        =   -1  'True
      Caption         =   "Digital Data: "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   195
      Left            =   5520
      TabIndex        =   11
      Top             =   1080
      Width           =   1140
   End
   Begin VB.Label Label2 
      Caption         =   "DriverLINX Device Number: "
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3000
      TabIndex        =   5
      Top             =   720
      Width           =   2055
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   360
      Left            =   360
      TabIndex        =   2
      Top             =   240
      Width           =   1845
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Height          =   255
      Left            =   480
      TabIndex        =   0
      Top             =   2880
      Width           =   4335
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim DOData() As Byte

Const bufSize = 100  ' how many data points to read
'
'  tested in Win98SE with KPCMCIA-PIO24-C
'  using KPCMCIA-850A04 version of the DriverLINX driver
'



Private Sub cmdExit_Click()
' stop any task that might be active
With SR
.Req_op = DL_STATUS
.Refresh
End With
' if the status operation can succeed, the task must be active
' and therefore needs stopped before exit
If SR.Res_result = DL_NoErr Then
SR.Req_op = DL_STOP
SR.Refresh
End If
' unload the driver for each object
SR.Req_DLL_name = ""
LDD.Req_DLL_name = ""
' exit
End
End Sub

Private Sub cmdInit_Click()
' open driver and initialize hardware
With SR
.Req_DLL_name = "kpcpio$"  ' driver name for KPCMCIA-PIO24-C cards
' init the hardware
.Req_device = devNum.ListIndex  ' device number assigned in DLinx Config Panel
.Req_mode = DL_OTHER
.Req_op = DL_INITIALIZE
.Req_subsystem = DL_DEVICE
.Refresh
End With
If SR.Res_result <> DL_NoErr Then
' respond to error
lblStatus.Caption = SR.Message
Else
' no error occured
LDD.Req_DLL_name = SR.Req_DLL_name
LDD.device = SR.Req_device
LDD.Refresh
Form1.Caption = "Paced Digital Input with " & LDD.Dev_Model
cmdInit.Enabled = False
cmdStart.Enabled = True
lblStatus.Caption = "Board Ready"
End If
Form1.SetFocus
End Sub

Private Sub cmdStart_Click()
Frame1.Enabled = False ' disallow clock select
List1.Clear
lblStatus.Caption = "Starting task......"
With SR
' Request Group
.Req_op = DL_START
.Req_mode = DL_INTERRUPT  ' could be DL_DMA if board has DMA feature
.Req_subsystem = DL_DI
' Event Group
.Evt_Str_type = DL_COMMAND  ' start when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop automatically
.Evt_Tim_type = DL_RATEEVENT ' timing will be used
.Evt_Tim_rateChannel = DL_DEFAULTTIMER
If optInternal.Value = True Then
.Evt_Tim_rateClock = DL_INTERNAL1       ' internal1 PC clock timebase
Else
.Evt_Tim_rateClock = DL_EXTERNAL ' will use the default rising edge of external signal
End If
.Evt_Tim_rateGate = DL_NOCONNECT   ' no gating
.Evt_Tim_rateMode = DL_RATEGEN     ' one sample for each tic of clock
'.Evt_Tim_rateOnCount = 0   ' not used for RATEGEN
'.Evt_Tim_rateOutput = CT_Output_Default ' not used for RATEGEN
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 1000) ' 1000 Hz rate is upper
' limit for the internal PC System Clock
' Select Group
.Sel_chan_format = DL_tNATIVE  ' use the card's native format
.Sel_chan_N = 1                ' a single channel
.Sel_chan_start = 0            ' start on channel 0
' allocate one buffer for the data
.Sel_buf_N = 1                 ' one buffer used
.Sel_buf_samples = bufSize
' the buffer MUST be a multiple of how many channels are in the scan
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
End With

SR.Refresh  '  now carry out the task
If SR.Res_result <> DL_NoErr Then
' respond to error
lblStatus.Caption = SR.Message
Else
' no error occured
If optInternal.Value = False Then
lblStatus.Caption = "Task Underway...Apply TTL clock signal to Pin 1."
Else
lblStatus.Caption = "Task Underway..."
End If
cmdStart.Enabled = False
End If
End Sub

Private Sub Form_Load()
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i  ' put legal values for device number into our combo box
Next i
devNum.ListIndex = 0 ' set it equal to first entry
End Sub

Private Sub optExternal_Click()
lblStatus.Caption = " Apply TTL clock signal to Pin 1"
End Sub

Private Sub optInternal_Click()
lblStatus.Caption = " PC System clock will be used for pacing"
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)

' allocate an array for the Digital Input data
ReDim DOData(bufSize) As Byte
Dim i As Integer
Dim dummy As Single

' move data from memory buffer to local array
dummy = SR.VBArrayBufferXfer(bufIndex, DOData(), DL_BufferToVBArray)

For i = 0 To 9
List1.AddItem "reading #: " & Str(i) & " " & Str(DOData(i))
Next i
lblStatus.Caption = "Task complete...."
cmdStart.Enabled = True
Frame1.Enabled = True  ' enable clock select

End Sub
